<?php

class Aroos_REST_Social_Media_Controller extends Aroos_REST_Controller
{
    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'aroos/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'social_media_links';

    /**
     * Register all routes releated with stores
     *
     * @return void
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_items'),
                'args' => $this->get_collection_params(),
                'permission_callback' => array($this, 'get_social_media_links_permissions_check'),
            ),
        ));
    }

    /**
     * Get social media links permissions check
     * 
     * @return bool
     */
    public function get_social_media_links_permissions_check()
    {
        return true;
    }

    /**
     * Get a collection of posts
     * 
     * @param WP_REST_Request $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_items($request)
    {
        $data = array(
            'twitter' => get_field('twitter_link', 'option'),
            'instagram' => get_field('instagram_link', 'option'),
            'youtube' => get_field('youtube_link', 'option'),
            'phone' => get_field('phone', 'option')
        );

        $response = rest_ensure_response($data);

        return $response;
    }
}