<?php

class Aroos_REST_Singer_Category_Controller extends Aroos_REST_Controller
{
    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'aroos/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'singer_categories';

    /**
     * Register all routes releated with stores
     *
     * @return void
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_items'),
                'args' => $this->get_collection_params(),
                'permission_callback' => array($this, 'get_singer_category_permissions_check'),
            ),
        ));
    }

    /**
     * Get singer category permissions check
     * 
     * @return bool
     */
    public function get_singer_category_permissions_check()
    {
        return true;
    }

    /**
     * Get a collection of posts
     * 
     * @param WP_REST_Request $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_items($request)
    {
        $response = rest_ensure_response(array(
            'data' => array_values(get_taxonomy_hierarchy('monshed-category', 0, $request)),
        ));

        return $response;
    }
}