<?php

/**
 * Recursively get taxonomy and its children
 *
 * @param string $taxonomy
 * @param int $parent - parent term id
 * @param WP_Request $request
 * @return array
 */
function get_taxonomy_hierarchy( $taxonomy, $parent = 0, $request ) {
	// only 1 taxonomy
	$taxonomy = is_array( $taxonomy ) ? array_shift( $taxonomy ) : $taxonomy;
	// get all direct descendants of the $parent
	$terms = get_terms( array( 'taxonomy' => $taxonomy, 'parent' => $parent, 'orderby' => 'term_order', 'order' => 'ASC' ) );
	// prepare a new array.  these are the children of $parent
	// we'll ultimately copy all the $terms into this new array, but only after they
	// find their own children
	$children = array();
	// go through all the direct descendants of $parent, and gather their children
	foreach ( $terms as $term ){
	    if (!empty($request['exclude'])) {
	        $exclude = explode(',', $request['exclude']);
	        
	        if (in_array($term->term_id, $exclude)) {
	            continue;
	        }
	    }
		// recurse to get the direct descendants of "this" term
		$term->children = get_taxonomy_hierarchy( $taxonomy, $term->term_id, $request );
		$term->thumbnail = wp_get_attachment_image_url(get_field('img', $taxonomy . '_' . $term->term_id), 'medium');

		// add the term to our new array
		$children[] = $term;
	}
	// send the results back to the caller
	return $children;
}