<?php

/**
 * API registrat class
 * 
 * @since 1.0.0
 * @package aroos-api
 */
class Aroos_API_Manager
{
    /**
     * Class dir and class name mapping
     *
     * @var array
     */
    protected $class_map; 

    /**
     * Aroos_API_Manager Constructor.
     */
    public function __construct()
    {
        if (!class_exists('WP_REST_Server')) {
            return;
        }

        $this->class_map = apply_filters('aroos_api_class_map', array(
            'orders' => 'Aroos_REST_Order_Controller',
            'singers' => 'Aroos_REST_Singer_Controller',
            'weddings' => 'Aroos_REST_Wedding_Controller',
            'videos' => 'Aroos_REST_Video_Controller',
            'locations' => 'Aroos_REST_Location_Controller',
            'banks' => 'Aroos_REST_Bank_Controller',
            'photos' => 'Aroos_REST_Photo_Controller',
            'wedding-categories' => 'Aroos_REST_Wedding_Category_Controller',
            'singer-categories' => 'Aroos_REST_Singer_Category_Controller',
            'video-categories' => 'Aroos_REST_Video_Category_Controller',
            'settings' => 'Aroos_REST_Setting_Controller',
            'sliders' => 'Aroos_REST_Slider_Controller',
            'social-media-links' => 'Aroos_REST_Social_Media_Controller',
        ));

        add_action('rest_api_init', array($this, 'register_rest_routes'), 10);
    }

    /**
     * Register REST API routes.
     *
     * @return void
     */
    public function register_rest_routes()
    {
        foreach ($this->class_map as $file_name => $controller) {
            $this->load_controller($file_name);
            $controller = new $controller();
            $controller->register_routes();
        }
    }

    /**
     * Load controller for REST API
     * 
     * @return void
     */
    public function load_controller($class = '')
    {
        global $aroos_api;

        if ('' != $class) {
            require_once $aroos_api->plugin_path . '/includes/class-api-' . $class . '-controller.php';
        }
    }
}