<?php 
/*================================================================================================
    MSC FUNCTIONS
=================================================================================================*/
add_action('init', 'do_output_buffer');
function do_output_buffer() {
        ob_start();
}

function custom_excerpt_length( $length ) {
    return 20;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function noor_page_id($page_name){
    $args = [
        'post_type' => 'page',
        'nopaging' => true,
        'meta_key' => '_wp_page_template',
        'meta_value' => $page_name.".php",
    ];
    $pages = get_posts( $args );
    foreach ( $pages as $page ){
        $page_id = $page->ID;
    }
    return get_page_link($page_id);
}

function noor_page_id2($page_name){
    $args = [
        'post_type' => 'page',
        'nopaging' => true,
        'meta_key' => '_wp_page_template',
        'meta_value' => $page_name.".php",
    ];
    $pages = get_posts( $args );
    foreach ( $pages as $page ){
        $page_id = $page->ID;
    }
    return $page_id;
}

/*================================================================================================
    Post Views Functions
=================================================================================================*/

function elnoor_getPostViews($postID){
    $count = get_post_meta($postID, 'post_views_count', true);
    if($count == ''){
        update_post_meta($postID, 'post_views_count', '0');
    }
    return $count;
}
function elnoor_setPostViews($postID) {
    $count = get_post_meta($postID, 'post_views_count', true);
    if($count == ''){
        $count = 0;
    }else{
        $count++;
    }
    update_post_meta($postID, 'post_views_count', $count);
}


/*================================================================================================
    Time since posted
=================================================================================================*/

function elnoor_get_time_since_posted() {

	$time_since_posted = human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) ;

	return $time_since_posted;

}



