<!doctype html>
<html lang="ar" dir="rtl">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <link rel="shortcut icon" href="<?php the_field('set1','option'); ?>" />
        <meta name="description" content="<?php the_field('set2','option'); ?>">
        <meta name="keywords" content="<?php the_field('set3','option'); ?>">
        <?php wp_head()?>
	</head>
	<body>
   		<header>
   		    <div class="bg-primary text-white py-24">
   		        <div class="container">
   		            <div class="headertop d-flex flex-wrap align-items-center justify-content-between">
   		                <div class="d-flex flex-wrap align-items-center mb-3 mb-lg-0">
   		                    <p class="font-15 line-15 mb-0 mr-4">
   		                        <i class="fas fa-map-marker-alt mr-2"></i>
   		                        <a class="text-white" href="<?php the_field('address_link','option');?>"><?php the_field('address','option');?></a>
   		                    </p>
   		                    <p class="font-15 line-15 mb-0 mr-4">
   		                        <i class="far fa-calendar-alt mr-2"></i>
   		                        <?php echo date_i18n( get_option( 'date_format' ), time() ); ?>
   		                    </p>
   		                </div>
   		                <div class="d-flex flex-wrap align-items-center">
                            <a class="font-18 text-white line-15 mb-0 mr-4 font-w500 text-ltr d-block" href="tel:<?php the_field('phone','option');?>">
   		                        <i class="fa fa-phone ml-2"></i>
   		                        <?php the_field('phone','option');?>
   		                    </a>
                            <ul class="sharesocial border border-w1">
                               <?php get_template_part('partials/content/general/social');?>
							</ul>
							<a class="ml-1 border rounded-circle img-h30 text-center" href="#"><img style="height:12px" src="https://zfatt.com/wp-content/uploads/2020/05/4sharedlogo-1.png" alt=""></a>
                        </div>
   		            </div>
   		        </div>
   		    </div>
   		    <div class="headerbg py-4">
				<div class="container">
					<div class="d-flex align-items-center justify-content-between">
						<a class="d-flex align-items-center" href="<?php echo home_url();?>">
							<h1 class="font-25 mb-0 text-primary mr-4"><font color="#FFFFFF">
                            <span style="background-color: #3E435F">زفات</span></font></h1>
							<img class="img-h80 img-lg-h120" src="<?php the_field('logo','option');?>" alt="">
						</a>
						<?php
						wp_nav_menu( array(
						'theme_location'  => 'header_nav',
						'container' => '',
						'depth'	          => 2,
						'menu_class'      => '',
						'fallback_cb'     => 'WP_Bootstrap_Navwalker::fallback',
						'walker'          => new WP_Bootstrap_Navwalker(),
						));
						?>
						<?php $old_cart = $_SESSION['thecart']; $count = count($old_cart) - 1 ;
						if($count != 0){
						?>
						<ul class="navbar-nav ml-3">
							<li class="nav-item">
								<a href="<?php echo noor_page_id('templates/template-cart'); ?>" class="nav-link position-relative">
									<i class="fa fa-shopping-cart font-22"></i>
									<span class="numbernavlink position-absolute bg-danger text-white rounded-circle img-h20 text-center font-14"><?php echo $count;?></span>
								</a>
							</li>
						</ul>
						<?php }?>
					</div>
				</div>
			</div>
			
            <div class="bg-primary headerbg_search headerbg_searchbutton">
                <div class="container">
                    <form action="<?php echo home_url();?>">
                        <input name="s" type="text" placeholder="ابدأ البحث...">
                        <span class="headerbg_searchtimes headerbg_searchbutton2"><i class="fa fa-times"></i></span>
                    </form>
                </div>
            </div>
   		</header>