<?php
// Register Required Plugins
define('THEMEY','Elnoor_');
require_once 'config/config-plugins.php';

// Main
require_once 'config/config-theme.php';
require_once 'config/config-scripts.php';
require_once 'config/config-acf.php';
require_once 'config/config-post-types.php';


require_once 'inc/helpers.php';
require_once 'inc/navwalker.php';


add_action('init','elnoor_add_to_cart');
function elnoor_add_to_cart(){
    session_start();
    if(!in_array($_GET['add_to_cart'],$_SESSION['thecart'])){
        $_SESSION['thecart'][] = intval($_GET['add_to_cart']);
    }
    return $_SESSION['thecart'];
}


add_action('init','elnoor_remove_to_cart');
function elnoor_remove_to_cart(){
    $post_id = intval($_GET['remove_from_cart']);
    if(isset($_GET['remove_from_cart'])){
        if(in_array($post_id,$_SESSION['thecart'])){
            if (($key = array_search($post_id, $_SESSION['thecart'])) !== false) {
                unset($_SESSION['thecart'][$key]);  
            }
        }
    }
}




function elnoor_add_order($order_num){ 
    $errors = array();
    if($_POST['fullname'] == NULL){
            $errors[] = "حقل الاسم مطلوب !";  
    }
    if($_POST['phone'] == NULL){
            $errors[] = " حقل الهاتف مطلوب !";
    }
    if($_POST['country'] == NULL){
            $errors[] = " حقل الدولة مطلوب !";
    }
    if($_POST['kind'] == NULL){
            $errors[] = " يجب اختيار نوع المناسبة !";
    }
    if($_POST['date'] == NULL){
            $errors[] = " يجب اختيار تاريخ المناسبة !";
    }
    if(empty($errors)){
        $post_id = wp_insert_post(array(
        'post_title'=> ' طلب جديد من  '. $_POST['fullname'],
        'post_status'=>'publish',
        'post_type'=>'all_orders',
        ));
        if($_FILES['payment_image']){
            require_once( ABSPATH . 'wp-admin/includes/image.php' );
            require_once( ABSPATH . 'wp-admin/includes/file.php' );
            require_once( ABSPATH . 'wp-admin/includes/media.php' );
            $attachment_id = media_handle_upload( 'payment_image', $post_id );
            update_field('payment_image',$attachment_id,$post_id);
        } 
        update_field('fullname',$_POST['fullname'],$post_id);
        update_field('phone',$_POST['phone'],$post_id);
        update_field('country',$_POST['country'],$post_id);
        update_field('kind',$_POST['kind'],$post_id);
        update_field('date',$_POST['date'],$post_id);
        update_field('ordernum',$order_num ,$post_id);
        update_field('field_5e5fe53ea44a1',$_SESSION['the_order'],$post_id);
		wp_set_object_terms($post_id,5,'order-statue');
    session_destroy();    
    }
    return $errors;
}



function elnoor_get_order_statue(){
    $order_num = intval($_GET['order_num']);
    $args = array(
    'numberposts' => -1,
    'post_type'   => 'all_orders'
    );
    $all_orders = get_posts( $args );
    foreach($all_orders as $order){
        if(get_field('ordernum',$order->ID) == $order_num){
            $status = get_the_terms($order->ID, 'order-statue');
			$phone = get_field('phone',$order->ID);
            $statue = $status[0]->name;
        }
    }
    if($statue == NULL){
        echo '<p class="bg-primary p-2 text-white text-center mt-24">عفواً لا يوجد طلب مطابق لرقم الطلب الذي ادخلته !</p>';
    }else{
        echo '<p class="bg-primary p-2 text-white text-center mt-24">'.$statue.'</p>' ;
    }
	sendSMS('wajdy','0533466691',$statue,$phone,'RawaeeK-AD');	
    wp_die();
}

add_action( 'wp_ajax_elnoor_get_order_statue', 'elnoor_get_order_statue' );
add_action( 'wp_ajax_nopriv_elnoor_get_order_statue', 'elnoor_get_order_statue' );


header("Content-Type: text/html; charset=utf-8");
function sendSMS($oursmsusername,$oursmspassword,$messageContent,$mobileNumber,$senderName){
$user = $oursmsusername;
$password = $oursmspassword;
$sendername = $senderName;
$text = urlencode( $messageContent);
$to = $mobileNumber;
$url = "http://sms.des4you.net/api/sendsms.php?username=$user&password=$password&numbers=$to&message=$text&sender=$sendername&unicode=E&return=full";
$ret = file_get_contents($url);
}




function save_audio_duration($post_id) {
    $file_id = intval(get_field('audio', $post_id));
	$file = get_attached_file($file_id);
	require_once(ABSPATH . "wp-admin" . '/includes/media.php');
	$data = wp_read_audio_metadata($file);
	return $data['length_formatted'];
}