<?php get_header(); the_post(); /* Template Name: ارشيف الفيديوهات */ ?>
<aside>
    <?php get_template_part('partials/content/general/title-map');?>
    <div class="bg-white py-4 py-lg-58">
        <div class="container">

            <div class="row row-col-xl">
                <?php 
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array('post_type' => 'video',
                'posts_per_page' => 12,
                'paged'=>$paged,             
                );
                $wp_query2 = new WP_Query( $args );
                while ( $wp_query2->have_posts() ) : $wp_query2->the_post();
                ?>
                <div class="col-lg-4 col-md-6">
                    <a class="d-block border bg-white hoverbg-primary" href="<?php the_permalink();?>">
                        <img class="img-wfull img-h220" src="<?php the_post_thumbnail_url(); ?>" alt="">
                        <div class="p-4">
                            <h3 class="font-16 m-0"><?php the_title();?></h3>
                        </div>
                    </a>
                </div>
                <?php endwhile; wp_reset_query(); ?>
            </div>
            <div class="pagination">
            <?php
            global $wp_query2;
            
            $big = 999999999; // need an unlikely integer
            
            echo paginate_links( array(
            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var('paged') ),
            'total' => $wp_query2->max_num_pages,
            'prev_text'          => __('<'),
            'next_text'          => __('>'),
            ) );
            ?>
            </div>

        </div>
    </div>

</aside>
<?php get_footer()?>