<?php
get_header(); the_post();
$queried_object = get_queried_object();
$term_id = $queried_object->term_id;
$children = get_term_children($term_id,'video-category');
?> 
<aside>
    <div class="bg-white py-4 py-lg-58">
        <div class="container">
            <h3 class="font-22 font-md-24 font-lg-30 mb-4 mb-lg-5 title-border-sm title-border primary">
                <?php single_term_title(); ?>
            </h3>
            <div class="row row-col-xl">
                <?php if(empty($children)){?>
                <?php 
                $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
                $args = array('post_type' => 'video',
                'posts_per_page' => 12,
                'paged'=>$paged,
                'tax_query' => array(
                    array(
                    'taxonomy' => 'video-category',
                    'field'    => 'id',
                    'terms'    => $term_id,
                    ),
                ),
                );
                $wp_query2 = new WP_Query( $args );
                while ( $wp_query2->have_posts() ) : $wp_query2->the_post();
                ?>
                <div class="col-lg-4 col-md-6">
                    <a class="d-block border bg-white hoverbg-primary" href="<?php the_permalink();?>">
                        <img class="img-wfull img-h220" src="<?php the_post_thumbnail_url(); ?>" alt="">
                        <div class="p-4">
                            <h3 class="font-16 m-0"><?php the_title();?></h3>
                        </div>
                    </a>
                </div>
                <?php endwhile; wp_reset_query(); ?>
            </div>
        <?php }else{
        foreach($children as $child){
        $term = get_term_by('id', $child,'video-category');
        $link = get_term_link($term);
        ?>
            <div class="col-lg-4 col-md-4">
                <div class="blocksoundesblock bg-white mb-3 shadow-sm rounded p-3">
                <a href="<?php echo $link; ?>" class="blocksoundes position-relative d-block">
                <img class="img-wfull img-h200 rounded" src="<?php the_field('img',$term); ?>" alt="">
                <div class="blocksoundes__hover text-center text-white rounded d-flex align-items-center justify-content-center">
                    <h4 class="m-0 font-16">
                        <?php echo $term->name; ?>
                    </h4>
                </div>
                </a>
                </div>
            </div>
        <?php }} ?>
            
            <div class="pagination">
            <?php
            global $wp_query2;
            
            $big = 999999999; // need an unlikely integer
            
            echo paginate_links( array(
            'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var('paged') ),
            'total' => $wp_query2->max_num_pages,
            'prev_text'          => __('<'),
            'next_text'          => __('>'),
            ) );
            ?>
            </div>

        </div>
    </div>

</aside>
<?php get_footer()?>