<?php 
if(!is_user_logged_in()){
    wp_redirect(home_url());
    exit;
}
get_header(); the_post();
/*
*Template Name: الملف الشخصي 
*/
$user = wp_get_current_user();
?>
  	<aside>
<?php get_template_part('partials/content/general/title-map');?>
    	    <div class="py-4 py-lg-7">
    	        <div class="container">
                    <div class="bg-white shadow rounded-xl p-5 mb-4 mb-lg-5">
                        <div class="d-block d-lg-flex justify-content-between align-items-center">
                            <div class="d-block d-lg-flex justify-content-between align-items-center">
                                <img class="img-h90 img-lg-h150 rounded-circle mr-4" src="<?php the_field('profile_image','user_'.$user->ID); ?>" alt="">
                                <div class="d-inline-block">
                                    <h3 class="font-22 mb-2">
                                        <?php echo $user->display_name; ?>
                                    </h3>
                                </div>
                            </div>
                            <div class="mt-4 mt-lg-0">
                                <p class="font-18 mb-24 mb-lg-4 line-10"><i class="fa fa-globe mr-2"></i> الدولة: <?php the_field('country','user_'.$user->ID); ?></p>
                                <p class="font-18 mb-24 mb-lg-4 line-10"><i class="fa fa-phone mr-2"></i> رقم الهاتف: <a href="tel:<?php the_field('phone','user_'.$user->ID); ?>"><?php the_field('phone','user_'.$user->ID); ?></a> </p>
                                <a href="<?php echo noor_page_id('templates/template-edit-profile'); ?>" class="btn btn-primary btn-mw150 mt-2">تعديل الملف الشخصي</a>
                            </div>
                        </div>
                    </div>
                    
                    <h3 class="font-20 font-lg-28 text-center mb-4 mb-lg-5">
                        الدورات المشترك بها
                    </h3>
                    
                    <div class="row justify-content-center row-col-xl">
                        <?php 
                        $args = array(
                        'post_type' => 'course',
                        'meta_key'     => 'course_type',	
                        'meta_value'   => 2,               
                        );
                        $wp_query2 = new WP_Query( $args );
                        while ( $wp_query2->have_posts() ) : $wp_query2->the_post();
                        $paid_users = get_field('paid_users');
                        if(in_array($user->ID,$paid_users)){
                        ?> 
                        <div class="col-lg-3 col-md-6">
                             <?php get_template_part('partials/loop/loop-course-paid');?>
                        </div>
                        <?php } endwhile; wp_reset_query(); ?>

                    </div>
                    
                </div>
            </div>
    	</aside>      
<?php get_footer()?>