<?php 
/*================================================================================================
    MSC FUNCTIONS
=================================================================================================*/
wp_deregister_script('jquery');


add_action('init', 'do_output_buffer');
function do_output_buffer() {
        ob_start();
}

function custom_excerpt_length( $length ) {
    return 10;
}
add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );

function noor_page_id($page_name){
    $args = [
        'post_type' => 'page',
        'nopaging' => true,
        'meta_key' => '_wp_page_template',
        'meta_value' => $page_name.".php",
    ];
    $pages = get_posts( $args );
    foreach ( $pages as $page ){
        $page_id = $page->ID;
    }
    return get_page_link($page_id);
}

function noor_page_id2($page_name){
    $args = [
        'post_type' => 'page',
        'nopaging' => true,
        'meta_key' => '_wp_page_template',
        'meta_value' => $page_name.".php",
    ];
    $pages = get_posts( $args );
    foreach ( $pages as $page ){
        $page_id = $page->ID;
    }
    return $page_id;
}

/*================================================================================================
    Post Views Functions
=================================================================================================*/

function elnoor_getPostViews($postID){
    $count = get_post_meta($postID, 'post_views_count', true);
    if($count == ''){
        update_post_meta($postID, 'post_views_count', '0');
    }
    return $count;
}
function elnoor_setPostViews($postID) {
    $count = get_post_meta($postID, 'post_views_count', true);
    if($count == ''){
        $count = 0;
    }else{
        $count++;
    }
    update_post_meta($postID, 'post_views_count', $count);
}


/*================================================================================================
    Time since posted
=================================================================================================*/

function elnoor_get_time_since_posted() {

	$time_since_posted = human_time_diff( get_the_time( 'U' ), current_time( 'timestamp' ) ) ;

	return $time_since_posted;

}

/*================================================================================================
   bankpayment 
=================================================================================================*/
function elnoor_add_bankpayment(){ 
    $fullname = sanitize_text_field($_POST['fullname']);
    $phone = sanitize_text_field($_POST['phone']);
    $email = sanitize_text_field($_POST['email']);
    $user_id = intval(get_current_user_id());
    $errors = array();
    if($fullname == NULL){
            $errors[] = "حقل الاسم مطلوب !";  
    }
    if($phone == NULL){
            $errors[] = " حقل الهاتف مطلوب !";
    }
    if($email == NULL){
            $errors[] = " حقل البريد الالكتروني مطلوب !";
    }
    if(empty($errors)){
        $post_id = wp_insert_post(array(
        'post_title'=> ' دفع بنكي من '. $fullname,
        'post_status'=>'pending',
        'post_author' => $user_id,
        'post_type'=>'bankpayment',
        ));
        update_field( "fullname", $fullname,$post_id );
        update_field( "phone", $phone,$post_id );
        update_field( "email", $email,$post_id );
        update_field('paid_course',$_GET['course_id'],$post_id);
        if($_FILES['payment_image']){
            require_once( ABSPATH . 'wp-admin/includes/image.php' );
            require_once( ABSPATH . 'wp-admin/includes/file.php' );
            require_once( ABSPATH . 'wp-admin/includes/media.php' );
            $attachment_id = media_handle_upload( 'payment_image', $post_id );
            update_field( "payment_image", $attachment_id,$post_id );
        }        
    }
    return $errors;
}


function elnoor_save_user_to_course( $post_id ) {
    if(get_post_status($post_id) === 'publish' && get_post_type($post_id) === 'bankpayment'){
        $post_author_id = intval(get_post_field( 'post_author', $post_id ));
            $course_id = get_field('paid_course',$post_id);
            $paid_users = get_field('paid_users',$course_id);
            if(!in_array($post_author_id ,$paid_users)){
                $paid_users[] = $post_author_id;
            }
            update_field('paid_users',$paid_users,$course_id);
    }
}
add_action( 'save_post', 'elnoor_save_user_to_course' );

/*================================================================================================
   update user data 
=================================================================================================*/


function elnoor_update_user_data($user){ 
    $name = sanitize_text_field($_POST['username']);
    $myemail = sanitize_email($_POST['email']);
    $phone = sanitize_text_field($_POST['phone']);
    $facebook = sanitize_text_field($_POST['facebook']);
    $profile_image = $_FILES['profile_image'];
        $user_id = wp_update_user( array(
        'ID' => $user->ID,
        'user_email' => $myemail,
        'display_name' => $name,
        ));
    update_field( "phone", $phone, "user_" . $user_id );
    update_field( "country", $country, "user_" . $user_id );;
    require_once( ABSPATH . 'wp-admin/includes/image.php' );
    require_once( ABSPATH . 'wp-admin/includes/file.php' );
    require_once( ABSPATH . 'wp-admin/includes/media.php' );      
    $attachment_id = media_handle_upload( 'profile_image',"user_" . $user_id  ); 
    update_field('profile_image',$attachment_id,"user_" . $user_id ); 
}