<?php

class Aroos_REST_Setting_Controller extends Aroos_REST_Controller
{
    /**
     * Endpoint namespace
     *
     * @var string
     */
    protected $namespace = 'aroos/v1';

    /**
     * Route name
     *
     * @var string
     */
    protected $base = 'settings';

    /**
     * Register all routes releated with stores
     *
     * @return void
     */
    public function register_routes()
    {
        register_rest_route($this->namespace, '/' . $this->base, array(
            array(
                'methods' => WP_REST_Server::READABLE,
                'callback' => array($this, 'get_items'),
                'args' => $this->get_collection_params(),
                'permission_callback' => array($this, 'get_setting_permissions_check'),
            ),
        ));
    }

    /**
     * Get setting permissions check
     * 
     * @return bool
     */
    public function get_setting_permissions_check()
    {
        return true;
    }

    /**
     * Get a collection of posts
     * 
     * @param WP_REST_Request $request
     * @return WP_Error|WP_REST_Response
     */
    public function get_items($request)
    {
        $post = get_post((int) $request['post_id']);
        $data = array();

        if ($post) {
            $data = get_field('home', $post->ID);
            
            foreach ($data as $home) {
                if ($home['acf_fc_layout'] == 'home4') {
                    $data = $home;
                    unset($data['acf_fc_layout']);
                }
            }
        }

        $response = rest_ensure_response($data);

        return $response;
    }
}