<?php

/**
 * Aroos Api Plugin
 * 
 * Aroos Api Core
 * 
 * @author AbdallahMohammed
 * @package aroos-api/core
 * @version 1.0.0
 */

class AroosAPI
{
    /**
     * Store the plugin base name
     * 
     * @var string
     */
    public $plugin_base_name;

    /**
     * Store the plugin url
     * 
     * @var string
     */
    public $plugin_url;

    /**
     * Store the plugin path
     * 
     * @var string
     */
    public $plugin_path;

    /**
     * Store the plugin textdomain
     * 
     * @var string
     */
    public $textdomain;

    /**
     * AroosAPI Constructor.
     */
    public function __construct($file)
    {
        $this->plugin_base_name = plugin_basename($file);
        $this->plugin_url = trailingslashit(plugins_url('', $file));
        $this->plugin_path = trailingslashit(dirname($file));
        
        add_action('init', array($this, 'init_aroos_api'));
        add_action('plugins_loaded', array($this, 'aroos_api_loaded'));
    }

    /**
     * Init function
     * 
     * @return void
     */
    public function init_aroos_api()
    {
        $this->load_textdomain();
        $this->load_class('rest-controller');
        $this->load_class('manager');

        new Aroos_API_Manager();
    }

    /**
     * @return void
     */
    public function aroos_api_loaded()
    {
        add_filter('jwt_auth_whitelist', function ($endpoints) {
            return array(
                '/wp-json/aroos/v1/orders/*',
                '/wp-json/aroos/v1/singers/*',
                '/wp-json/aroos/v1/weddings/*',
                '/wp-json/aroos/v1/videos/*',
                '/wp-json/aroos/v1/locations/*',
                '/wp-json/aroos/v1/banks/*',
                '/wp-json/aroos/v1/photos/*',
                '/wp-json/aroos/v1/wedding_categories/*',
                '/wp-json/aroos/v1/singer_categories/*',
                '/wp-json/aroos/v1/video_categories/*',
                '/wp-json/aroos/v1/settings/*',
                '/wp-json/aroos/v1/sliders/*',
            );
        });        
    }

    /**
     * Load localization files
     * 
     * @return void
     */
    public function load_textdomain()
    {
        $locale = function_exists('get_user_locale') ? get_user_locale() : get_locale();
        $locale = apply_filters('plugin_locale', $locale);

        load_textdomain('aroos-api', $this->plugin_path . 'lang/aroos-api-' . $locale . '.mo');
        load_textdomain('aroos-api', WP_LANG_DIR . 'plugins/aroos-api-' . $locale . '.mo');
    }

    /**
     * Load class
     * 
     * @param string $class
     * @return void
     */
    public function load_class($class = '')
    {
        if ('' != $class) {
            require_once 'class-' . esc_attr(AROOS_TOKEN) . '-' . esc_attr($class) . '.php';
        }
    }
}